<?php namespace Visiosoft\RotaModule\Command;

use Illuminate\Console\Command;
use Visiosoft\RotaModule\Product\Contract\ProductRepositoryInterface;
use Visiosoft\RotaModule\RotaModule;

class RotaCreateProductCommand extends Command
{
    protected $signature = 'rota:create_product';

    protected $description = 'create new product to rota';

    public function __construct()
    {
        parent::__construct();
    }

    public function handle()
    {
        $rota = app(RotaModule::class);
        $productRepository = app(ProductRepositoryInterface::class);
        $pending_products = $productRepository->findBy('sended', false, "get");

        foreach ($pending_products as $pending_product) {
            $rota->createProduct($pending_product->toArray());
        }

    }
}
