<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleRotaCreateCustomerStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = false;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'customer',
        'title_column' => 'name',
        'translatable' => false,
        'versionable' => false,
        'trashable' => true,
        'searchable' => false,
        'sortable' => false,
    ];


    protected $fields = [
        'customer_id' => "anomaly.field_type.text",
        'name' => "anomaly.field_type.text",
        'phone' => "anomaly.field_type.text",
        'gsm' => "anomaly.field_type.text",
        'tax_office' => "anomaly.field_type.text",
        'tax_number' => "anomaly.field_type.text",
        'identity_number' => "anomaly.field_type.text",
        'email' => "anomaly.field_type.text",
        'address' => "anomaly.field_type.text",
        'city' => "anomaly.field_type.text",
        'state' => "anomaly.field_type.text",
        'zipcode' => "anomaly.field_type.text",
        'country' => "anomaly.field_type.text"
    ];


    /**
     * The stream assignments.
     *
     * @var array
     */

    protected $assignments = [
        'customer_id',
        'name',
        'phone',
        'gsm',
        'tax_office',
        'tax_number',
        'identity_number',
        'email',
        'address',
        'city',
        'state',
        'zipcode',
        'country',
        'rota_id',
        'sended',
        'sended_at'
    ];

}
