<?php namespace Visiosoft\RotaModule\Receipt\Listener;


use Visiosoft\RotaModule\Receipt\Contract\ReceiptRepositoryInterface;

class CreateReceipt
{
    public function __construct(ReceiptRepositoryInterface $receiptRepository)
    {
        $this->receiptRepository = $receiptRepository;
    }

    public function handle(\Visiosoft\RotaModule\Events\ReceiptCreated $event)
    {
        $params = $event->getparams();
        if (!$this->receiptRepository->newQuery()->where('order_id',$params['order_id'])->exists()) {
            $this->receiptRepository->create($params);
        }
        throw new \Exception("Receipt already exists");
    }
}


