<?php namespace Visiosoft\RotaModule\Customer\Listener;

use Visiosoft\RotaModule\Customer\Contract\CustomerRepositoryInterface;

class CreateCustomer
{
    public function __construct(CustomerRepositoryInterface $customerRepository)
    {
        $this->customerRepository = $customerRepository;
    }

    public function handle(\Visiosoft\RotaModule\Events\CustomerCreated $event)
    {
        $params = $event->getParams();
        if (!$this->customerRepository->findBy('customer_id', $params['customer_id'])) {
            $this->customerRepository->create($params);
        }
    }
}


