<?php namespace Visiosoft\RotaModule\Command;

use Illuminate\Console\Command;
use Visiosoft\RotaModule\Customer\Contract\CustomerRepositoryInterface;
use Visiosoft\RotaModule\RotaModule;

class RotaCreateCustomerCommand extends Command
{
    protected $signature = 'rota:create_customer';

    protected $description = 'create new customer to rota';

    public function __construct()
    {
        parent::__construct();
    }

    public function handle()
    {
        $rota = app(RotaModule::class);
        $customerRepository = app(CustomerRepositoryInterface::class);
        $pending_customers = $customerRepository->findBy('sended', 0, "get");
        foreach ($pending_customers as $pending_customer) {
            $rota->createCustomer($pending_customer->toArray());
        }

    }
}
