<?php namespace Visiosoft\RotaModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Visiosoft\LocationModule\City\Contract\CityRepositoryInterface;
use Visiosoft\LocationModule\Country\Contract\CountryRepositoryInterface;
use Visiosoft\LocationModule\District\Contract\DistrictRepositoryInterface;
use Visiosoft\OrdersModule\Orderdetail\Contract\OrderdetailRepositoryInterface;
use Visiosoft\OrdersModule\Orderpayment\Contract\OrderpaymentRepositoryInterface;
use Visiosoft\ProfileModule\Adress\Contract\AdressRepositoryInterface;
use Visiosoft\RotaModule\Invoice\Contract\InvoiceRepositoryInterface;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;

class InvoiceController extends PublicController
{

    private $orderdetailRepository;
    private $orderpaymentRepository;
    private $advRepository;
    private $invoiceRepository;
    private $adressRepository;
    private $cityRepository;
    private $districtRepository;
    private $countryRepository;

    public function __construct(
        OrderdetailRepositoryInterface $orderdetailRepository,
        OrderpaymentRepositoryInterface $orderpaymentRepository,
        AdvRepositoryInterface $advRepository,
        InvoiceRepositoryInterface $invoiceRepository,
        AdressRepositoryInterface $adressRepository,
        CityRepositoryInterface $cityRepository,
        DistrictRepositoryInterface $districtRepository,
        CountryRepositoryInterface $countryRepository
    )
    {
        parent::__construct();
        $this->orderdetailRepository = $orderdetailRepository;
        $this->orderpaymentRepository = $orderpaymentRepository;
        $this->advRepository = $advRepository;
        $this->invoiceRepository = $invoiceRepository;
        $this->adressRepository = $adressRepository;
        $this->cityRepository = $cityRepository;
        $this->districtRepository = $districtRepository;
        $this->countryRepository = $countryRepository;
    }

    public function handlePaymentOrder($user, $orderPaymentsId)
    {
        $requestData = $this->getRequestData($user, $orderPaymentsId);
        $response = $this->createRotaInvoiceAPI($requestData);
        if (is_array($response) && isset($response['error']) && $response['error']) {
            $this->messages->error(trans('visiosoft.module.rota::message.create_invoice_error'));
        } else {
            $invoiceId = $this->createInvoice($response);

            $this->messages->success(trans('visiosoft.module.rota::message.create_invoice_success', [
                'id' => $invoiceId
            ]));
        }
    }

    public function getRequestData($user, $orderPaymentsId)
    {
        $requestData = array();

        $addressData = $this->getAddress($user->id);
        $orderPayment = $this->orderpaymentRepository->find($orderPaymentsId);
        $orderDetail = $this->orderdetailRepository->find($orderPayment->getAttribute("order-detail_id"));
        $adv = $this->advRepository->find($orderDetail->item_id);

        $date = date('Y-m-d H:i:s');
        $date = str_replace(" ","%20", $date);

        $requestData['email'] = $user->email;
        $requestData['itemcode'] = $orderDetail->item_id;
        $description = $adv->name;
        $requestData['description'] = urlencode($description);
        $requestData['invdescription'] = urlencode($description);
        $requestData['qty'] = $orderDetail->piece;
        $requestData['amount'] = $orderDetail->total;
        $requestData['currency'] = setting_value('visiosoft.module.rota::currency');
        $requestData['vdairesi'] = setting_value('visiosoft.module.rota::vdairesi');
        $requestData['vkn'] = $user->identification_number ? $user->identification_number : setting_value('visiosoft.module.rota::vkn');
        $requestData['currencyvalue'] = setting_value('visiosoft.module.rota::currency_value');
        $requestData['api_key'] = setting_value('visiosoft.module.rota::api_key');
        $requestData['code'] = $user->username;
        $requestData['name'] = $user->first_name . '+' . $user->last_name;
        $requestData['tax_rate'] = setting_value('visiosoft.module.rota::tax_rate');
        $requestData['tax'] = $requestData['amount'] * $requestData['tax_rate'] / 100;
        $requestData['discount'] = setting_value('visiosoft.module.rota::discount');
        $requestData['total'] = $requestData['amount'] - $requestData['discount'];
        $requestData['account'] = setting_value('visiosoft.module.rota::account');
        $requestData['date'] = $date;
        $requestData['duedate'] = $date;
        $requestData['address'] = $addressData['address'];
        $requestData['state'] = $addressData['state'];
        $requestData['city'] = $addressData['city'];
        $requestData['country'] = $addressData['country'];
        $requestData['nationality'] = $requestData['country'];

        return $requestData;
    }

    public function createRotaInvoiceAPI($requestInfo)
    {
        $url = setting_value('visiosoft.module.rota::api_url') . '&method=invoices&unit=Piece&kdvdh=1';
        foreach ($requestInfo as $key => $value) {
            $url .= "&$key=$value";
        }
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);

        curl_close($curl);

        if ($err) {
            return ['error' => true];
//            dd("cURL Error #:" . $err);
        } else {
            $response = json_decode($response);
            if (isset($response->error) && $response->error) {
                return ['error' => true];
            } else {
                return $response;
            }
        }
    }

    public function createInvoice($response)
    {
        $invoice = $this->invoiceRepository->create([
            'invoice_id' => $response->id
        ]);
        return $invoice->id;
    }

    public function getAddress($userId)
    {
        $addressData = array();

        $address = $this->adressRepository->findBy('user_id', $userId);

        $addressData['address'] = $address->adress_name;
        $addressData['state'] = $this->cityRepository->find($address->city)->name;
        $addressData['city'] = $this->districtRepository->find($address->district)->name;
        $addressData['country'] = $this->countryRepository->find($address->country_id)->name;

        foreach ($addressData as $index => $value) {
            $addressData[$index] = str_replace(" ","%20", $value);
        }

        return $addressData;
    }
}
