<?php namespace Visiosoft\RotaModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Anomaly\Streams\Platform\Model\Rota\RotaReceiptEntryModel;
use Visiosoft\RotaModule\Command\RotaCreateCustomerCommand;
use Visiosoft\RotaModule\Command\RotaCreateInvoiceCommand;
use Visiosoft\RotaModule\Command\RotaCreateProductCommand;
use Visiosoft\RotaModule\Command\RotaCreateReceiptCommand;
use Visiosoft\RotaModule\Customer\Contract\CustomerRepositoryInterface;
use Visiosoft\RotaModule\Customer\CustomerRepository;
use Anomaly\Streams\Platform\Model\Rota\RotaCustomerEntryModel;
use Visiosoft\RotaModule\Customer\CustomerModel;
use Visiosoft\RotaModule\Events\ReceiptCreated;
use Visiosoft\RotaModule\Product\Contract\ProductRepositoryInterface;
use Visiosoft\RotaModule\Product\ProductRepository;
use Anomaly\Streams\Platform\Model\Rota\RotaProductEntryModel;
use Visiosoft\RotaModule\Product\ProductModel;
use Visiosoft\RotaModule\Invoice\Contract\InvoiceRepositoryInterface;
use Visiosoft\RotaModule\Invoice\InvoiceRepository;
use Anomaly\Streams\Platform\Model\Rota\RotaInvoiceEntryModel;
use Visiosoft\RotaModule\Invoice\InvoiceModel;
use Visiosoft\RotaModule\Events\CustomerCreated;
use Visiosoft\RotaModule\Events\OrderCreated;
use Visiosoft\RotaModule\Events\ProductCreated;
use Visiosoft\RotaModule\Receipt\Contract\ReceiptRepositoryInterface;
use Visiosoft\RotaModule\Receipt\ReceiptModel;
use Visiosoft\RotaModule\Receipt\ReceiptRepository;

class RotaModuleServiceProvider extends AddonServiceProvider
{

    protected $commands = [
        RotaCreateCustomerCommand::class,
        RotaCreateProductCommand::class,
        RotaCreateInvoiceCommand::class,
        RotaCreateReceiptCommand::class
    ];


    protected $schedules = [
        '* * * * *' => [
            RotaCreateCustomerCommand::class,
            RotaCreateProductCommand::class,
            RotaCreateInvoiceCommand::class,
            RotaCreateReceiptCommand::class
        ]
    ];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        ProductCreated::class => [
            \Visiosoft\RotaModule\Product\Listener\CreateProduct::class
        ],
        OrderCreated::class => [
            \Visiosoft\RotaModule\Invoice\Listener\CreateInvoice::class,
        ],
        CustomerCreated::class => [
            \Visiosoft\RotaModule\Customer\Listener\CreateCustomer::class,
        ],
        ReceiptCreated::class => [
            \Visiosoft\RotaModule\Receipt\Listener\CreateReceipt::class,
        ]
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        RotaCustomerEntryModel::class => CustomerModel::class,
        RotaProductEntryModel::class => ProductModel::class,
        RotaInvoiceEntryModel::class => InvoiceModel::class,
        RotaReceiptEntryModel::class => ReceiptModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        CustomerRepositoryInterface::class => CustomerRepository::class,
        ProductRepositoryInterface::class => ProductRepository::class,
        InvoiceRepositoryInterface::class => InvoiceRepository::class,
        ReceiptRepositoryInterface::class => ReceiptRepository::class,
    ];
}
