<?php namespace Visiosoft\RotaModule\Customer;

use Visiosoft\RotaModule\Customer\Contract\CustomerRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;
use Visiosoft\RotaModule\Helper\Helper;

class CustomerRepository extends EntryRepository implements CustomerRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var CustomerModel
     */
    protected $model;

    /**
     * Create a new CustomerRepository instance.
     *
     * @param CustomerModel $model
     */

    protected $helper;

    public function __construct(CustomerModel $model, Helper $helper)
    {
        $this->model = $model;
        $this->helper = $helper;
    }

    public function findBy($type, $value, $list_type = "first")
    {
        return $this->model->newQuery()->where($type,$value)->$list_type();
    }

    public function listByRota(array $queryString)
    {
        return $this->helper->request("GET", "/v3.0.0/api/chk/list", $queryString, []);
    }

    public function addToRota(array $params)
    {
        return $this->helper->request("POST", "/v3.0.0/api/chk/add", [], json_encode($params));
    }

    public function updateByRota(array $params)
    {
        return $this->helper->request("PUT", "/v3.0.0/api/chk/update", [], json_encode($params));
    }
}
