<?php namespace Visiosoft\RotaModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\RotaModule\Command\RotaCreateCustomerCommand;
use Visiosoft\RotaModule\Command\RotaCreateInvoiceCommand;
use Visiosoft\RotaModule\Command\RotaCreateProductCommand;
use Visiosoft\RotaModule\Customer\Contract\CustomerRepositoryInterface;
use Visiosoft\RotaModule\Customer\CustomerRepository;
use Anomaly\Streams\Platform\Model\Rota\RotaCustomerEntryModel;
use Visiosoft\RotaModule\Customer\CustomerModel;
use Visiosoft\RotaModule\Product\Contract\ProductRepositoryInterface;
use Visiosoft\RotaModule\Product\ProductRepository;
use Anomaly\Streams\Platform\Model\Rota\RotaProductEntryModel;
use Visiosoft\RotaModule\Product\ProductModel;
use Visiosoft\RotaModule\Invoice\Contract\InvoiceRepositoryInterface;
use Visiosoft\RotaModule\Invoice\InvoiceRepository;
use Anomaly\Streams\Platform\Model\Rota\RotaInvoiceEntryModel;
use Visiosoft\RotaModule\Invoice\InvoiceModel;
use Visiosoft\RotaModule\Events\CustomerCreated;
use Visiosoft\RotaModule\Events\OrderCreated;
use Visiosoft\RotaModule\Events\ProductCreated;

class RotaModuleServiceProvider extends AddonServiceProvider
{

    protected $commands = [
        RotaCreateCustomerCommand::class,
        RotaCreateProductCommand::class,
        RotaCreateInvoiceCommand::class
    ];


    protected $schedules = [
        '* * * * *' => [
            RotaCreateCustomerCommand::class,
            RotaCreateProductCommand::class,
            RotaCreateInvoiceCommand::class
        ]
    ];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/rota/customer' => 'Visiosoft\RotaModule\Http\Controller\Admin\CustomerController@index',
        'admin/rota/customer/create' => 'Visiosoft\RotaModule\Http\Controller\Admin\CustomerController@create',
        'admin/rota/customer/edit/{id}' => 'Visiosoft\RotaModule\Http\Controller\Admin\CustomerController@edit',
        'admin/rota/product' => 'Visiosoft\RotaModule\Http\Controller\Admin\ProductController@index',
        'admin/rota/product/create' => 'Visiosoft\RotaModule\Http\Controller\Admin\ProductController@create',
        'admin/rota/product/edit/{id}' => 'Visiosoft\RotaModule\Http\Controller\Admin\ProductController@edit',
        'admin/rota' => 'Visiosoft\RotaModule\Http\Controller\Admin\InvoiceController@index',
        'admin/rota/create' => 'Visiosoft\RotaModule\Http\Controller\Admin\InvoiceController@create',
        'admin/rota/edit/{id}' => 'Visiosoft\RotaModule\Http\Controller\Admin\InvoiceController@edit',
    ];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        ProductCreated::class => [
            \Visiosoft\RotaModule\Product\Listener\CreateProduct::class
        ],
        OrderCreated::class => [
            \Visiosoft\RotaModule\Invoice\Listener\CreateInvoice::class,
        ],
        CustomerCreated::class => [
            \Visiosoft\RotaModule\Customer\Listener\CreateCustomer::class,
        ]
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        RotaCustomerEntryModel::class => CustomerModel::class,
        RotaProductEntryModel::class => ProductModel::class,
        RotaInvoiceEntryModel::class => InvoiceModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        CustomerRepositoryInterface::class => CustomerRepository::class,
        ProductRepositoryInterface::class => ProductRepository::class,
        InvoiceRepositoryInterface::class => InvoiceRepository::class,
    ];
}
