<?php namespace Visiosoft\RotaModule\Product;

use Visiosoft\RotaModule\Helper\Helper;
use Visiosoft\RotaModule\Product\Contract\ProductRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class ProductRepository extends EntryRepository implements ProductRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var ProductModel
     */
    protected $model;

    /**
     * Create a new ProductRepository instance.
     *
     * @param ProductModel $model
     */
    public function __construct(ProductModel $model, Helper $helper)
    {
        $this->model = $model;
        $this->helper = $helper;
    }

    public function findBy($type, $value, $list_type = "first")
    {
        return $this->model->newQuery()->where($type, $value)->$list_type();
    }

    public function listByRota(array $queryString)
    {
        return $this->helper->request("GET", "/v3.0.0/api/stk/list", $queryString, []);
    }

    public function stockListByWarehouse($queryString)
    {
        return $this->helper->request("GET", "/v3.0.0/api/stk/warehouseItemBalance", $queryString, []);
    }

    public function addToRota(array $params)
    {
        return $this->helper->request("POST", "/v3.0.0/api/stk/add", [], json_encode($params));
    }

    public function updateByRota(array $params)
    {
        return $this->helper->request("PUT", "/v3.0.0/api/stk/update", [], json_encode($params));
    }

}
