<?php namespace Visiosoft\RotaModule\Invoice;

use Visiosoft\RotaModule\Helper\Helper;
use Visiosoft\RotaModule\Invoice\Contract\InvoiceRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class InvoiceRepository extends EntryRepository implements InvoiceRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var InvoiceModel
     */
    protected $model;

    /**
     * Create a new InvoiceRepository instance.
     *
     * @param InvoiceModel $model
     */

    protected $helper;

    public function __construct(InvoiceModel $model, Helper $helper)
    {
        $this->model = $model;
        $this->helper = $helper;
    }

    public function findBy($type, $value, $list_type = "first")
    {
        return $this->model->newQuery()->where($type, $value)->$list_type();
    }

    public function listByRota(array $queryString)
    {
        return $this->helper->request("GET", "/v3.0.0/api/order/list", $queryString, []);
    }

    public function addToRota(array $params)
    {
        return $this->helper->request("POST", "/v3.0.0/api/order/add", [], json_encode($params));
    }

    public function updateByRota(array $params)
    {
        return $this->helper->request("PUT", "/v3.0.0/api/order/update", [], json_encode($params));
    }
}
