<?php namespace Visiosoft\RotaModule\Events;

use Illuminate\Foundation\Bus\DispatchesJobs;
use Visiosoft\ConnectModule\Command\CheckRequiredParams;

class CustomerCreated
{

    use DispatchesJobs;

    protected $params;

    public function __construct($params)
    {
        $this->dispatch(new CheckRequiredParams([
            'customer_id',
            'name',
            'phone',
            'tax_office',
            'tax_number',
            'identity_number',
            'email',
            'address',
            'city',
            'state',
            'zipcode',
            'country'
        ], $params));
        $this->params = $params;
    }

    public function getParams()
    {
        return $this->params;
    }
}
