<?php namespace Visiosoft\RotaModule\Helper;
class Helper
{
    public function auth()
    {
        $username = setting_value('visiosoft.module.rota::username');
        $password = setting_value('visiosoft.module.rota::password');

        $params = ['username' => $username, 'password' => $password];
        $request = $this->request("POST", "/api/login", [], $params, true);
        return $request->token;
    }


    public function request($method, $url, $queryString = [], $params = [], $auth = false)
    {
        $apiUrl = setting_value('visiosoft.module.rota::api_url');
        $curl = curl_init();

        $header = [];
        if (!$auth) {
            $header = [
                'Authorization: Bearer ' . $this->auth() . '',
                'Content-Type: application/json'
            ];
        }

        $params = str_replace("stdClass Object", "", $params);
        curl_setopt_array($curl, array(
            CURLOPT_URL => $apiUrl . $url . '?' . http_build_query($queryString),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_CUSTOMREQUEST => $method,
            CURLOPT_POSTFIELDS => $params,
            CURLOPT_HTTPHEADER => $header
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        return json_decode($response);

    }
}