<?php namespace Visiosoft\RotaExtension\Traits;

use Anomaly\UsersModule\Role\Contract\RoleRepositoryInterface;
use Carbon\Carbon;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use Visiosoft\CatsModule\Category\Contract\CategoryRepositoryInterface;
use Visiosoft\RotaExtension\Log\Command\CreateRequestLog;

trait RequestRota
{

    public function __construct()
    {
        dispatch_now(new CreateRequestLog(request()->all(), request()->getMethod(), request('type')));
    }

    public function checkRequireParameters()
    {
        $require_parameters = array_combine($this->require_parameters, $this->require_parameters);
        $require_parameters = array_map(function ($v) {
            return 'required';
        }, $require_parameters);

        $validator = Validator::make(request('values'), $require_parameters);

        if ($validator->fails()) {

            $errors = implode(', ', $validator->errors()->all());
            throw new \Exception($errors, 400);
            die;
        }
    }

    public function getOwner()
    {
        $roles = app(RoleRepositoryInterface::class);

        $adminRole = $roles->findBySlug('admin');
        $admins = $adminRole->getUsers();

        return $admins->first();
    }

    public function getCategory($category)
    {
        $categories = app(CategoryRepositoryInterface::class);

        if (!$entry = $categories->newQuery()->translate()->where('name', $category)->first()) {
            $entry = $categories->newQuery()
                ->create([
                    'name' => $category,
                    'slug' => Str::slug($category, '_'),
                    'created_by_id' => $this->getOwner(),
                    'created_at' => Carbon::now()
                ]);
        }

        return $entry;
    }
}