<?php namespace Visiosoft\RotaExtension;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\RotaExtension\Log\Contract\LogRepositoryInterface;
use Visiosoft\RotaExtension\Log\LogRepository;
use Anomaly\Streams\Platform\Model\Rota\RotaLogEntryModel;
use Visiosoft\RotaExtension\Log\LogModel;
use Illuminate\Routing\Router;

class RotaExtensionServiceProvider extends AddonServiceProvider
{
    protected $bindings = [
        RotaLogEntryModel::class => LogModel::class,
    ];

    protected $singletons = [
        LogRepositoryInterface::class => LogRepository::class,
    ];


    public function map(Router $router)
    {
        $router->post(
            'rota/webhook/{token}',
            [
                'as' => 'visiosoft.extension.rota::webhook',
                'uses' => 'Visiosoft\RotaExtension\Http\Controller\WebhookController@webhook',
            ]
        )->middleware([
            \Visiosoft\RotaExtension\Http\Middleware\TokenVerify::class,
            \Visiosoft\RotaExtension\Http\Middleware\CheckParameters::class,
        ]);
    }
}
