<?php namespace Visiosoft\RotaExtension;

use Anomaly\Streams\Platform\Database\Seeder\Seeder;

class RotaExtensionSeeder extends Seeder
{
    public function run()
    {
        $stream = $this->streams->findBySlugAndNamespace('advs', 'advs');

        $new_fields = [
            [
                'name' => 'Rota Entry ID',
                'slug' => 'rota_entry_id',
                'type' => 'anomaly.field_type.integer',
            ],
        ];

        foreach ($new_fields as $field_value) {
            if (!$field = $this->fields->findBySlugAndNamespace($field_value['slug'], 'advs')) {
                $field = $this->fields->create($field_value);
            }

            if (!$this->assignments->findByStreamAndField($stream, $field)) {
                $this->assignments->create([
                    'field' => $field,
                    'stream' => $stream
                ]);
            }
        }
    }
}
