<?php namespace Visiosoft\RotaExtension\Log\Command;

use Visiosoft\RotaExtension\Log\Contract\LogRepositoryInterface;

class CreateRequestLog
{
    protected $method;
    protected $request_values;
    protected $service;
    protected $response_values;
    protected $status;

    public function __construct($request_values, $method, $service, $response_values = null, $status = null)
    {
        $this->request_values = $request_values;
        $this->method = $method;
        $this->service = $service;
        $this->response_values = $response_values;
        $this->status = $status;
    }

    public function handle(LogRepositoryInterface $logs)
    {
        $logs->create([
            'service' => $this->service,
            'request_method' => $this->method,
            'request' => json_encode($this->request_values),
            'response' => $this->response_values,
            'response_status' => $this->status,
        ]);
    }
}