<?php namespace Visiosoft\RotaExtension\Http\Middleware;

use Closure;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Http\Request;

class TokenVerify
{
    use DispatchesJobs;

    public function handle(Request $request, Closure $next)
    {
        $token = $request->token;

        if (env('AUTO_TOKEN') == $token) {
            return $next($request);
        }

        return response()->json([
            'success' => false,
            'message' => trans('streams::message.access_denied'),
        ],401);
    }
}
