<?php namespace Visiosoft\RotaExtension\Http\Middleware;

use Closure;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class CheckParameters
{
    use DispatchesJobs;

    public function handle(Request $request, Closure $next)
    {

        $validator = Validator::make($request->all(), [
            'type' => 'required',
            'values' => 'required|array',
        ]);

        if ($validator->fails()) {
            return response()->json(['success' => false, 'errors' => $validator->errors()], 400);
        }

        return $next($request);
    }
}
