<?php namespace Visiosoft\RotaExtension\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Illuminate\Support\Str;

class WebhookController extends PublicController
{
    public function webhook()
    {
        $class = "Visiosoft\RotaExtension\Commands\\" . Str::studly($this->request->type);

        if (!class_exists($class)) {
            return response()->json(['success' => false, 'errors' => "Type not found!"], 400);
        }

        try {
            $entry = call_user_func([app($class), 'handle']);
        } catch (\Exception $exception) {
            if (in_array($exception->getCode(), [400, 404])) {
                return response()->json(['success' => false, 'errors' => $exception->getMessage()], 400);
            }
            return response()->json(['success' => false, 'errors' => (env('APP_DEBUG')) ? $exception->getMessage() : trans('streams::error.500.name')], 400);
        }

        return $this->response->json(['success' => true, 'data' => $entry]);
    }
}