<?php namespace Visiosoft\RotaExtension\Commands;

use Anomaly\UsersModule\Role\Contract\RoleRepositoryInterface;
use Carbon\Carbon;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\CatsModule\Category\Contract\CategoryRepositoryInterface;
use Visiosoft\RotaExtension\Traits\RequestRota;

class UpdateAdv
{
    use RequestRota;

    protected $require_parameters = [
        'name', 'description', 'category', 'price', 'currency', 'salable_product', 'stock', 'rota_entry_id'
    ];

    public function handle()
    {
        $this->checkRequireParameters();

        $values = request('values');

        $adv_repository = app(AdvRepositoryInterface::class);

        if (!$adv = $adv_repository->findBy('rota_entry_id', $values['rota_entry_id'])) {
            throw new \Exception('Ürün/ilan bulunamadı!', 404);
            die;
        }

        $entry = $adv->update([
            'updated_at' => Carbon::now(),
            'updated_by_id' => ($owner = $this->getOwner()) ? $owner->id : null,
            'name' => $values['name'],
            'advs_desc' => $values['description'],
            'slug' => Str::slug($values['name'], '_'),
            'cat1' => $this->getCategory($values['category'])->id,
            'price' => $values['price'],
            'is_get_adv' => $values['salable_product'],
            'stock' => $values['stock'],
            'currency' => $values['currency'],
            'rota_entry_id' => $values['rota_entry_id']
        ]);

        return ['entry_id' => $entry->id];
    }
}