<?php namespace Visiosoft\RotaExtension\Commands;

use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\RotaExtension\Traits\RequestRota;

class DeleteAdv
{
    use RequestRota;

    protected $require_parameters = [
        'rota_entry_id'
    ];

    public function handle()
    {
        $this->checkRequireParameters();

        $values = request('values');

        $adv_repository = app(AdvRepositoryInterface::class);

        if (!$adv = $adv_repository->findBy('rota_entry_id', $values['rota_entry_id'])) {
            throw new \Exception('Ürün/ilan bulunamadı!', 404);
            die;
        }

        return $adv->delete();
    }
}