<?php namespace Visiosoft\RotaExtension\Commands;

use Anomaly\UsersModule\Role\Contract\RoleRepositoryInterface;
use Carbon\Carbon;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\CatsModule\Category\Contract\CategoryRepositoryInterface;
use Visiosoft\RotaExtension\Log\Command\CreateRequestLog;
use Visiosoft\RotaExtension\Traits\RequestRota;

class CreateAdv
{
    use RequestRota;

    protected $require_parameters = [
        'name', 'description', 'category', 'price', 'currency', 'salable_product', 'stock', 'rota_entry_id'
    ];

    public function handle()
    {
        $this->checkRequireParameters();

        $values = request('values');
        $publish_time = setting_value('visiosoft.module.advs::default_published_time');

        $adv_repository = app(AdvRepositoryInterface::class);

        if ($adv_repository->findBy('slug', Str::slug($values['name'], '_'))) {
            throw new \Exception('Ürün/ilan zaten var!', 400);
            die;
        }

        $entry = $adv_repository->newQuery()
            ->create([
                'created_at' => Carbon::now(),
                'created_by_id' => ($owner = $this->getOwner()) ? $owner->id : null,
                'name' => $values['name'],
                'advs_desc' => $values['description'],
                'slug' => Str::slug($values['name'], '_'),
                'cat1' => $this->getCategory($values['category'])->id,
                'price' => $values['price'],
                'is_get_adv' => $values['salable_product'],
                'stock' => $values['stock'],
                'currency' => $values['currency'],
                'publish_at' => date('Y-m-d H:i:s'),
                'finish_at' => date('Y-m-d H:i:s', strtotime(date('Y-m-d H:i:s') . ' + ' . $publish_time . ' day')),
                'status' => 'approved',
                'rota_entry_id' => $values['rota_entry_id']
            ]);

        return ['entry_id' => $entry->id];
    }

    public function getOwner()
    {
        $roles = app(RoleRepositoryInterface::class);

        $adminRole = $roles->findBySlug('admin');
        $admins = $adminRole->getUsers();

        return $admins->first();
    }

    public function getCategory($category)
    {
        $categories = app(CategoryRepositoryInterface::class);

        if (!$entry = $categories->newQuery()->translate()->where('name', $category)->first()) {
            $entry = $categories->newQuery()
                ->create([
                    'name' => $category,
                    'slug' => Str::slug($category, '_'),
                    'created_by_id' => $this->getOwner(),
                    'created_at' => Carbon::now()
                ]);
        }

        return $entry;
    }
}