<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftExtensionRotaCreateLogStream extends Migration
{
    protected $delete = false;

    protected $stream = [
        'slug' => 'log',
        'title_column' => 'id',
        'translatable' => false,
        'versionable' => false,
        'trashable' => true,
        'searchable' => false,
        'sortable' => false,
    ];

    protected $fields = [
        'service' => 'anomaly.field_type.text',
        'request_method' => 'anomaly.field_type.text',
        'request' => [
            'type' => 'anomaly.field_type.textarea',
            'config' => [
                'default_value' => '{}'
            ],
        ],
        'response' => [
            'type' => 'anomaly.field_type.textarea',
            'config' => [
                'default_value' => '{}'
            ],
        ],
        'response_status' => 'anomaly.field_type.text'
    ];

    protected $assignments = [
        'service' => [
            'required' => true,
        ],
        'request_method' => [
            'required' => true,
        ],
        'request' => [
            'required' => true,
        ],
        'response',
        'response_status',
    ];
}
