<?php

return [
    "logo" => "anomaly.field_type.file",
    "logo_white" => "anomaly.field_type.file",
    "mobile_logo" => "anomaly.field_type.file",
    "home_background_image" => "anomaly.field_type.file",
    "print_logo" => "anomaly.field_type.file",
    "popular_cities" => [
        "type" => "anomaly.field_type.checkboxes",
        "config" => [
            "mode" => "tags",
            "options" => static function (\Visiosoft\LocationModule\City\CityModel $cityModel) {
                return $cityModel->all()->pluck('name', 'id')->all();
            },
        ]
    ],
    "facebook_address" => "anomaly.field_type.url",
    "instagram_address" => "anomaly.field_type.url",
    "twitter_address" => "anomaly.field_type.url",
    "linkedin_address" => "anomaly.field_type.url",
    "youtube_address" => "anomaly.field_type.url",
    "app_store" => "anomaly.field_type.url",
    "android_store" => "anomaly.field_type.url",
    "qr" => "anomaly.field_type.file",
    "footer_logo" => "anomaly.field_type.file",
    'free_post_message' => [
        'type' => 'anomaly.field_type.text',
        'config' => [
            'default_value' => 'Bireysel Üyeler 3 adete kadar ücretsiz ilan verebilir'
        ]
    ],
    'btn_color' => [
        'type' => 'anomaly.field_type.text',
    ],
    'warning_message' => [
        'type' => 'anomaly.field_type.textarea',
        "config" => [
            "default_value" => "The ad creator is solely responsible for the content, correctness, accuracy and legal obligation of all posted ads, entries, ideas and information. openclassify.com is not in any way responsible for the quality or legality of content created and posted by its users. You should contact the ad creator directly with your questions.",
        ]
    ],
    'list_cats' => [
        'type' => 'anomaly.field_type.checkboxes',
        'config' => [
            'mode' => 'tags',
            'options' => function () {
                return app(\Anomaly\PostsModule\Category\CategoryModel::class)->get()->pluck('name', 'id');
            }
        ]
    ],'ad_page_target' => [
        'type' => 'anomaly.field_type.select',
        "config" => [
            "options" => [
                'current' => "visiosoft.theme.restate::setting.current_page",
                'new' => "visiosoft.theme.restate::setting.new_page",
            ],
        ]
    ],
    'header_category1' => [
        'type' => 'anomaly.field_type.relationship',
        'config' => [
            'related' => \Visiosoft\CatsModule\Category\CategoryModel::class,
        ]
    ],
    'header_category2' => [
        'type' => 'anomaly.field_type.relationship',
        'config' => [
            'related' => \Visiosoft\CatsModule\Category\CategoryModel::class,
        ]
    ],
    'search_cat1' => [
        'type' => 'anomaly.field_type.relationship',
        'config' => [
            'related' => \Visiosoft\CatsModule\Category\CategoryModel::class,
        ]
    ],
    'search_cat2' => [
        'type' => 'anomaly.field_type.relationship',
        'config' => [
            'related' => \Visiosoft\CatsModule\Category\CategoryModel::class,
        ]
    ],'search_cat3' => [
        'type' => 'anomaly.field_type.relationship',
        'config' => [
            'related' => \Visiosoft\CatsModule\Category\CategoryModel::class,
        ]
    ],

    'address' => [
        'type' => 'anomaly.field_type.text',
    ],
    'phone' => [
        'type' => 'anomaly.field_type.text',
    ],
    'mail' => [
        'type' => 'anomaly.field_type.email',
    ],
    'company_name' => [
        'type' => 'anomaly.field_type.text',
    ],
    'company_desc' => [
        'type' => 'anomaly.field_type.text',
    ],
    'form_desc' => [
        'type' => 'anomaly.field_type.text',
    ],
];
