<?php

return [
    "logo" => "anomaly.field_type.file",
    "logo_white" => "anomaly.field_type.file",
    "home_background_image" => "anomaly.field_type.file",
    "print_logo" => "anomaly.field_type.file",
    "popular_cities" => [
        "type" => "anomaly.field_type.checkboxes",
        "config" => [
            "mode" => "tags",
            "options" => static function (\Visiosoft\LocationModule\City\CityModel $cityModel) {
                return $cityModel->all()->pluck('name', 'id')->all();
            },
        ]
    ],
    "facebook_address" => "anomaly.field_type.url",
    "instagram_address" => "anomaly.field_type.url",
    "twitter_address" => "anomaly.field_type.url",
    "linkedin_address" => "anomaly.field_type.url",
    "youtube_address" => "anomaly.field_type.url",
    "app_store" => "anomaly.field_type.url",
    "android_store" => "anomaly.field_type.url",
    "footer_logo" => "anomaly.field_type.file",
    'btn_color' => [
        'type' => 'anomaly.field_type.colorpicker',
        "config" => [
            "default_value" => '#061a46'
        ]
    ],
    'btn_color2' => [
        'type' => 'anomaly.field_type.colorpicker',
        "config" => [
            "default_value" => '#5226d2'
        ]
    ],
    'list_cats' => [
        'type' => 'anomaly.field_type.checkboxes',
        'config' => [
            'mode' => 'tags',
            'options' => function () {
                return app(\Anomaly\PostsModule\Category\CategoryModel::class)->get()->pluck('name', 'id');
            }
        ]
    ],'ad_page_target' => [
        'type' => 'anomaly.field_type.select',
        "config" => [
            "options" => [
                'current' => "visiosoft.theme.restate::setting.current_page",
                'new' => "visiosoft.theme.restate::setting.new_page",
            ],
        ]
    ],
    'header_category1' => [
        'type' => 'anomaly.field_type.relationship',
        'config' => [
            'related' => \Visiosoft\CatsModule\Category\CategoryModel::class,
        ]
    ],
    'header_category2' => [
        'type' => 'anomaly.field_type.relationship',
        'config' => [
            'related' => \Visiosoft\CatsModule\Category\CategoryModel::class,
        ]
    ],
    'search_cat1' => [
        'type' => 'anomaly.field_type.relationship',
        'config' => [
            'related' => \Visiosoft\CatsModule\Category\CategoryModel::class,
        ]
    ],
    'search_cat2' => [
        'type' => 'anomaly.field_type.relationship',
        'config' => [
            'related' => \Visiosoft\CatsModule\Category\CategoryModel::class,
        ]
    ],'search_cat3' => [
        'type' => 'anomaly.field_type.relationship',
        'config' => [
            'related' => \Visiosoft\CatsModule\Category\CategoryModel::class,
        ]
    ],'search_cat4' => [
        'type' => 'anomaly.field_type.relationship',
        'config' => [
            'related' => \Visiosoft\CatsModule\Category\CategoryModel::class,
        ]
    ],

    'address' => [
        'type' => 'anomaly.field_type.text',
    ],
    'phone' => [
        'type' => 'anomaly.field_type.text',
    ],
    'mail' => [
        'type' => 'anomaly.field_type.email',
    ],
    'company_name' => [
        'type' => 'anomaly.field_type.text',
    ],
    'company_desc' => [
        'type' => 'anomaly.field_type.text',
    ],
    'form_desc' => [
        'type' => 'anomaly.field_type.text',
    ],

    'mobile_intro_bg' => [
        'type' => 'anomaly.field_type.file'
    ],
    'contact_info_visible_to_login_user' => [
        'type' => 'anomaly.field_type.boolean'
    ],
    'shareWhatsappMsg' => [
        'type' => 'anomaly.field_type.textarea',
        "config" => [
            'default_value' => 'See what I found on Openclassify. Just look at the details.',
        ]
    ],
    'default_owner' => [
        "type" => "anomaly.field_type.relationship",
        "config" => [
            "related" => '\Anomaly\UsersModule\User\UserModel',
            "mode" => "search",
            "default_value" => null,
        ]
    ],
    'footer_doping_color' => [
        'type' => 'anomaly.field_type.colorpicker',
        "config" => [
            "default_value" => '#061a46'
        ]
    ],
];
