<?php namespace Visiosoft\ReportsModule\Report;

use Visiosoft\ReportsModule\Report\Contract\ReportInterface;
use Anomaly\Streams\Platform\Model\Reports\ReportsReportEntryModel;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ReportModel extends ReportsReportEntryModel implements ReportInterface
{
    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @return string
     */
    public function getSource(): string
    {
        return $this->source;
    }

    /**
     * @return string
     */
    public function getSourceAuthToken(): string
    {
        return $this->source_auth_token;
    }

    /**
     * @return string
     */
    public function getViewType(): string
    {
        return $this->view_type;
    }

    /**
     * @return string
     */
    public function getReportType(): string
    {
        return $this->report_type;
    }


    /**
     * @return string|null
     */
    public function getReportTable(): ?string
    {
        return $this->report_table;
    }

    /**
     * @return string|null
     */
    public function getColumn(): ?string
    {
        return $this->column;
    }

    /**
     * @return string|null
     */
    public function getTimeColumn(): ?string
    {
        return $this->time_column;
    }

    /**
     * @return string|null
     */
    public function getOperation(): ?string
    {
        return $this->operation;
    }

    /**
     * @return string|null
     */
    public function getDurationType(): ?string
    {
        return $this->duration_type;
    }

    /**
     * @return int|null
     */
    public function getDuration(): ?int
    {
        return $this->duration;
    }

    /**
     * @return string|null
     */
    public function getWhere(): ?string
    {
        return $this->where;
    }

    /**
     * @return string|null
     */
    public function getRawQuery(): ?string
    {
        return $this->raw_query;
    }

    /**
     * @param string $name
     * @return void
     */
    public function setName(string $name): void
    {
        $this->name = $name;
    }

    /**
     * @param string $source
     * @return void
     */
    public function setSource(string $source): void
    {
        $this->source = $source;
    }

    /**
     * @param string $sourceAuthToken
     * @return void
     */
    public function setSourceAuthToken(string $sourceAuthToken): void
    {
        $this->source_auth_token = $sourceAuthToken;
    }

    /**
     * @param string $viewType
     * @return void
     */
    public function setViewType(string $viewType): void
    {
        $this->view_type = $viewType;
    }

    /**
     * @param string $reportType
     * @return void
     */
    public function setReportType(string $reportType): void
    {
        $this->report_type = $reportType;
    }

    /**
     * @param string|null $reportTable
     * @return void
     */
    public function setReportTable(?string $reportTable): void
    {
        $this->report_table = $reportTable;
    }

    /**
     * @param string|null $column
     * @return void
     */
    public function setColumn(?string $column): void
    {
        $this->column = $column;
    }

    /**
     * @param string|null $timeColumn
     * @return void
     */
    public function setTimeColumn(?string $timeColumn): void
    {
        $this->time_column = $timeColumn;
    }

    /**
     * @param string|null $operation
     * @return void
     */
    public function setOperation(?string $operation): void
    {
        $this->operation = $operation;
    }

    /**
     * @param string|null $durationType
     * @return void
     */
    public function setDurationType(?string $durationType): void
    {
        $this->duration_type = $durationType;
    }

    /**
     * @param int|null $duration
     * @return void
     */
    public function setDuration(?int $duration): void
    {
        $this->duration = $duration;
    }

    /**
     * @param string|null $where
     * @return void
     */
    public function setWhere(?string $where): void
    {
        $this->where = $where;
    }

    /**
     * @param string|null $rawQuery
     * @return void
     */
    public function setRawQuery(?string $rawQuery): void
    {
        $this->raw_query = $rawQuery;
    }

}
