<?php

namespace Visiosoft\ReportsModule\Report\Form;

use Anomaly\Streams\Platform\Message\MessageBag;
use Visiosoft\ReportsModule\Helpers\QueryHelper;

class ReportFormHandler
{
    private array $formValues;

    public function handle(ReportFormBuilder $builder, MessageBag $messageBag)
    {
        $this->formValues = $builder->getFormValues()->toArray();

        if (!empty($this->formValues['raw_query']) && QueryHelper::isBlacklisted($this->formValues['raw_query'])) {
            $builder->addFormError('', '');
            $messageBag->error(trans('visiosoft.module.reports::message.blacklisted_query'));
        }

        $emptyColumns = $this->checkEmptyColumns();
        if ($emptyColumns) {
            $builder->addFormError('', '');
            $messageBag->error([$this->getEmptyColumnsMessage($emptyColumns)]);
        }


        $builder->saveForm();
    }

    private function getEmptyColumnsMessage(array $emptyColumns): string
    {
        $required = trans('visiosoft.module.reports::field.required');
        return implode(' ' . trans('visiosoft.module.reports::field.required') . ' <br>',
                $this->translateEmptyColumnFields($emptyColumns)) . " " . $required;
    }

    private function translateEmptyColumnFields(array $emptyColumns)
    {
        foreach ($emptyColumns as $emptyColumn) {
            return trans('visiosoft.module.reports::field.' . $emptyColumn);
        }

        return $emptyColumns;
    }

    private function checkEmptyColumns(): array
    {
        $columns = $this->formValues['report_type'] === "raw_query" ? $this->getRawQueryColumns() : $this->getPredefinedColumns();
        $emptyColumns = [];
        foreach ($columns as $column) {
            if (empty($this->formValues[$column])) {
                $emptyColumns[] = $column;
            }
        }
        return $emptyColumns;
    }

    private function getPredefinedColumns(): array
    {
        return ['report_table', 'column', 'time_column', 'operation', 'duration_type', 'duration'];
    }

    private function getRawQueryColumns(): array
    {
        return ['raw_query'];
    }
}