<?php

namespace Visiosoft\ReportsModule\Report\Form;

class ReportFormFields
{
    public function handle(ReportFormBuilder $builder)
    {
        $fields = [
            'name',
            'source',
            'source_auth_token',
            'view_type' => [
                'label' => "visiosoft.module.reports::field.view_type.name",
                'type' => "anomaly.field_type.select",
                'config' => [
                    'default_value' => 'table',
                    "options" => ['table' => 'visiosoft.module.reports::field.table.name', 'chart' => 'visiosoft.module.reports::field.chart.name'],
                    "separator" => ":",
                ],
            ],
            'report_type' => [
                'label' => "visiosoft.module.reports::field.report_type.name",
                'type' => "anomaly.field_type.select",
                'config' => [
                    'default_value' => 'predefined_columns',
                    "options" => ['raw_query' => 'visiosoft.module.reports::field.raw_query.name', 'predefined_columns' => 'visiosoft.module.reports::field.predefined_columns.name'],
                    "separator" => ":",
                ],
            ],
            'report_table' => [
                'class' => "form-control predefined_columns"
            ],
            'column' => [
                'class' => "form-control predefined_columns"
            ],
            'time_column' => [
                'class' => "form-control predefined_columns"
            ],
            'operation' => [
                'class' => "form-control predefined_columns"
            ],
            'duration_type' => [
                'class' => "form-control predefined_columns"
            ],
            'duration' => [
                'class' => "form-control predefined_columns"
            ],
            'where' => [
                'class' => "form-control predefined_columns"
            ],
            'raw_query' => [
                'class' => "form-control raw_query"
            ]
        ];

        $builder->setFields($fields);
    }
}