<?php

namespace Visiosoft\ReportsModule\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Visiosoft\ReportsModule\Token\Contract\TokenRepositoryInterface;
use Visiosoft\ReportsModule\Traits\ApiReturnResponseTrait;


class AuthAdminMiddleware
{
    use ApiReturnResponseTrait;

    public function handle(Request $request, Closure $next)
    {
        $token = request()->header('token');
        if (empty($token) || !app(TokenRepositoryInterface::class)->getByToken($token)) {
            return $this->sendError('Invalid Token', [], 401);
        }

        return $next($request);
    }
}
