<?php

namespace Visiosoft\ReportsModule\Http\Controller;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Visiosoft\ReportsModule\Helpers\QueryHelper;
use Visiosoft\ReportsModule\Traits\ApiReturnResponseTrait;

class ApiController
{
    use ApiReturnResponseTrait;

    public function getReportByQuery()
    {
        $query = request()->post('query');
        $validator = Validator::make(request()->all(), [
            'query' => ['required', 'string'],
        ]);

        if ($validator->fails()) {
            return $this->sendError($validator->errors(), [], 422);
        }

        if (QueryHelper::isBlacklisted($query)) {
            return $this->sendError('There are blacklisted statements in your query', [], 401);
        }


        return $this->sendResponse(DB::select($query));
    }

}