<?php namespace Visiosoft\ReportsModule\Report;

use Carbon\Carbon;
use DateTime;
use Illuminate\Support\Facades\DB;
use Visiosoft\ReportsModule\Report\Contract\ReportRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;
use Visiosoft\ReportsModule\Token\Contract\TokenRepositoryInterface;

class ReportRepository extends EntryRepository implements ReportRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var ReportModel
     */
    protected $model;
    private $now;
    private $durationType;
    private $duration;
    private $subDuration;

    private $operation;

    /**
     * Create a new ReportRepository instance.
     *
     * @param ReportModel $model
     */
    public function __construct(ReportModel $model)
    {
        $this->model = $model;
    }


    public function getReports()
    {
        return $this->model->newQuery()->get();
    }

    public function getReport($id)
    {
        $report = $this->model->find($id);
        if (!$report) {
            throw new \Exception("Report Not Found");
        }

        $column = $report->column;
        $table = $report->table;
        $where = $report->where;
        $timeColumn = $report->time_column;


        $this->operation = $report->operation;
        $this->now = Carbon::now();
        $this->durationType = $report->duration_type;
        $this->duration = $report->duration;
        $this->subDuration = Carbon::now()->sub($this->duration . $this->durationType);

        $query = DB::table($table)
            ->selectRaw("$this->durationType($timeColumn) as time, $this->operation($column) as total")
            ->whereBetween($timeColumn, [$this->subDuration, $this->now])
            ->groupBy('time');

        if ($where) {
            $query->whereRaw($where);
        }
        $query = $query->get();

        return $this->format($query);
    }

    private function format($query)
    {
        //Todo::remove comments when the getDates function is done.
        //$times = $this->getDatesWithFormat();
        foreach ($query as $q) {
            // $key = array_search($q->time, array_column($times, 'time'));
            if (strtolower($this->operation) === "sum") {
                $q->total = number_format($q->total, 2, '.', '');
            }
            /*
            if ($key) {
                $times[$key] = $q;
            }
            */
        }
        return $query;
    }


    private function getDatesWithFormat()
    {
        //Todo::Change The function for week and month
        $times = [];

        $durationType = strtolower($this->durationType);

        if ($durationType == "day") {
            for ($i = 0; $i < $this->duration; $i++) {
                if ($i == 0) {
                    $times[] = (object)['unit' => "day", 'time' => $this->now->format("d"), 'total' => 0];
                }
                $times[] = (object)['unit' => "day", 'time' => $this->now->sub("1 day")->format("d"), 'total' => 0];;
            }
        }


        return $times;

    }
}
