<?php namespace Visiosoft\ReportsModule\Report;

use Visiosoft\ReportsModule\Report\Contract\ReportInterface;
use Anomaly\Streams\Platform\Model\Reports\ReportsReportEntryModel;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ReportModel extends ReportsReportEntryModel implements ReportInterface
{
    protected $appends = ['api_endpoint'];

    public function getApiEndpointAttribute()
    {

        $baseUrl = $this->source != "localhost" ? $this->source : "";
        return $baseUrl . url("/api/report/get/{$this->id}/{$this->source_auth_token}");

    }
}
