<?php namespace Visiosoft\ReportsModule\Http\Controller;

use Carbon\Carbon;
use Visiosoft\ChargingModule\Http\Controller\PublicController;
use Visiosoft\ReportsModule\Report\Contract\ReportRepositoryInterface;
use Visiosoft\ReportsModule\Token\Contract\TokenRepositoryInterface;
use Yajra\DataTables\DataTables;

class ReportController extends PublicController
{
    private $reportsRepository;
    private $tokenRepository;

    public function __construct()
    {
        $this->reportsRepository = app(ReportRepositoryInterface::class);
        $this->tokenRepository = app(TokenRepositoryInterface::class);
    }

    public function getReports()
    {
        return $this->reportsRepository->getReports();
    }

    /**
     * @param $id
     * @param $authToken
     * @return mixed
     * @throws \Exception
     */
    public function getReport($id, $authToken)
    {
        $this->checkAuth($authToken);
        $reportData = $this->reportsRepository->getReport($id);

        return $reportData;

    }

    private function checkAuth($token)
    {
        if (!$token) {
            throw new \Exception('token-required');
        }

        if (!$token = $this->tokenRepository->findBy('token', $token)) {

            throw new \Exception('invalid-token');
        }

        if (!$token->status || $token->expire_date < Carbon::now()) {
            throw new \Exception('invalid-token');
        }




    }

}