$(document).ready(function () {
    let reportTypeInput = $('select[name="report_type"]');
    let selectedValue = reportTypeInput.val();

    getColumnsByReportType(selectedValue);

    reportTypeInput.change(function () {
        selectedValue = $(this).val();
        getColumnsByReportType(selectedValue);
    });
});

function getColumnsByReportType(selectedValue) {
    processColumns(".predefined_columns", selectedValue === "predefined_columns");
    processColumns(".raw_query", selectedValue === "raw_query", "-field");
}

function processColumns(selector, shouldShow, suffix = '') {
    $(selector).each(function () {
        let elem = $("." + $(this)[0].id + suffix);
        shouldShow ? elem.show() : elem.hide();
    });
}
