<?php namespace Visiosoft\ReportsModule\Token;

use Visiosoft\ReportsModule\Token\Contract\TokenRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class TokenRepository extends EntryRepository implements TokenRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var TokenModel
     */
    protected $model;

    /**
     * Create a new TokenRepository instance.
     *
     * @param TokenModel $model
     */
    public function __construct(TokenModel $model)
    {
        $this->model = $model;
    }

    public function getByToken(string $token)
    {
        return $this->model->where('token', $token)->first();
    }
}
