<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleReportsCreateReportStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = false;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'report',
        'title_column' => 'name',
        'translatable' => false,
        'versionable' => false,
        'trashable' => false,
        'searchable' => false,
        'sortable' => true,
    ];

    /**
     * The addon fields.
     *
     * @var array
     */
    protected $fields = [
        'name' => 'anomaly.field_type.text',
        'source' => [
            'type' => 'anomaly.field_type.text',
            'config' => [
                'default_value' => "localhost"
            ]
        ],
        'source_auth_token' => "anomaly.field_type.text",
        'report_type' => 'anomaly.field_type.text',
        'view_type' => 'anomaly.field_type.text',
        'report_table' => "anomaly.field_type.text",
        'column' => "anomaly.field_type.text",
        'time_column' => "anomaly.field_type.text",
        'operation' => [
            'type' => 'anomaly.field_type.select',
            'config' => [
                'default_value' => 'SUM',
                "options" => ['SUM' => 'SUM', 'COUNT' => 'COUNT'],
                "separator" => ":",
            ],
        ],
        'duration_type' => [
            'type' => 'anomaly.field_type.select',
            'config' => [
                'default_value' => 'day',
                "options" => ['day' => 'Day', 'week' => 'Week', 'month' => 'Month'],
                "separator" => ":",
            ],
        ],
        'duration' => [
            'type' => "anomaly.field_type.integer",
            'config' => [
                'default_value' => '30'
            ]
        ],
        'where' => "anomaly.field_type.text",
        'raw_query' => 'anomaly.field_type.textarea'
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'name' => [
            'required' => true
        ],
        'source' => [
            'required' => true
        ],
        'source_auth_token' => [
            'required' => true
        ],
        'report_type' => [
            'required' => true
        ],
        'view_type' => [
            'required' => true
        ],
        'report_table',
        'column',
        'time_column',
        'operation',
        'duration_type',
        'duration',
        'where',
        'raw_query'
    ];

}
