<?php

namespace Visiosoft\ReportsWidgetExtension\Command;

use Anomaly\DashboardModule\Widget\Contract\WidgetInterface;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Visiosoft\ReportsModule\Report\Contract\ReportInterface;
use Visiosoft\ReportsModule\Report\Contract\ReportRepositoryInterface;

class LoadItems
{

    use DispatchesJobs;

    protected WidgetInterface $widget;

    public function __construct(WidgetInterface $widget)
    {
        $this->widget = $widget;
    }

    public function handle(ReportRepositoryInterface $reportRepository)
    {
        $reports = $reportRepository->getReports();

        $reports = $reports->filter(
            function (ReportInterface $report) {
                return !$report->isParent();
            }
        );

        $this->widget->addData('reports', $reports);
    }
}
