function getTableData(endPoint, reportId) {
    $.ajax({
        url: endPoint,
        type: 'GET',
        dataType: 'json',
        success: function (response) {
            var data = response.entry.data;
            let tableHeader = $('#table-header-' + reportId);
            let tableBody = $('#table-data-' + reportId);

            $.each(data[0], function (key, value) {
                tableHeader.append('<th>' + key + '</th>');
            });

            $.each(data, function (index, row) {
                let newRow = $('<tr></tr>');
                $.each(row, function (key, cell) {
                    newRow.append('<td>' + cell + '</td>');
                });
                tableBody.append(newRow);
            });

            $('#table-' + reportId).DataTable({ordering: false, bInfo: false, bLengthChange: false});
        }
    });
}