let charts = $(".charts");
charts.each(function () {
    let chartContainer = $(this);
    $.ajax({
        method: "GET",
        url: $(this).data("api_endpoint"),
        accept: 'application/json',
        success: function (data) {
            let formattedData = formatData(data.entry.data)
            let formattedChilds = formatChilds(data.childs)
            let chartColor = random_rgba();
            const ctx = chartContainer;
            const myChart = new Chart(ctx, {
                type: data.entry.chartType,
                data: {
                    labels: formattedData.labels,
                    datasets: [
                        {
                            label: data.entry.name,
                            data: formattedData.datas,
                            backgroundColor: chartColor,
                            borderColor: chartColor,
                            tension: 0.4,
                            fill: true,
                            fillColor: chartColor, // Put the gradient here as a fill color
                            strokeColor: chartColor,
                            pointColor: "transparent",
                            pointStrokeColor: "transparent",
                            pointHighlightFill: "transparent",
                            pointHighlightStroke: "transparent",
                        }
                    ].concat(formattedChilds)
                },
                options: {
                    animation:false,
                    maintainAspectRatio: false,
                    legend: {
                        display: false
                    },
                    plugins: {
                        legend: {
                            display: true
                        },
                        title: {
                            display: false,
                        },
                        tooltip: {
                            enabled: true // <-- this option disables tooltips
                        }
                    },
                    interaction: {
                        intersect: false,
                    },
                    scales: {
                        x: {
                            ticks: {
                                beginAtZero: true
                            },
                            grid: {
                                display: false,
                            },
                            display: true,
                            title: {
                                display: false,
                            },
                        },
                        y: {
                            display: true,
                            title: {
                                display: false,
                            },
                            suggestedMin: 0,
                            suggestedMax: 50
                        }
                    }
                },
            });
        }
    })
})

function formatData(data) {
    let formatted = [];
    let formattedLabels = [];
    let formattedDatas = [];

    $.each(data, function (key, val) {
        formattedLabels.push(val.time);
        formattedDatas.push(val.total);
    })

    formatted.labels = formattedLabels;
    formatted.datas = formattedDatas;


    return formatted
}

function formatChilds(childs) {
    let formattedChilds = [];
    $.each(childs, function (i, v) {
        let color = random_rgba();

        let formatted = formatData(v.data);
        let dataset = {
            label: v.name,
            data: formatted.datas,
            backgroundColor: color,
            borderColor: color,
            tension: 0.4,
            fill: true,
            fillColor: random_rgba(), // Put the gradient here as a fill color
            strokeColor: random_rgba(),
            pointColor: "transparent",
            pointStrokeColor: "transparent",
            pointHighlightFill: "transparent",
            pointHighlightStroke: "transparent",
        };

        formattedChilds.push(dataset);
    })

    return formattedChilds;
}

function random_rgba() {
    var o = Math.round, r = Math.random, s = 200;
    return 'rgba(' + o(r() * s) + ',' + o(r() * s) + ',' + o(r() * s) + ',' + (0.4 + r() * 0.4).toFixed(1) + ')';
}