<?php

namespace Visiosoft\ReportsModule\Token\Form;

use Carbon\Carbon;
use Illuminate\Support\Str;

class TokenFormFields
{
    public function handle(TokenFormBuilder $builder)
    {
       $formEntry = $builder->getFormEntry();
        $fields = [
            'token' => [
                'value' => function () use ($formEntry) {
                    return $formEntry->token ?: sha1(Str::random());
                }
            ],
            'expire_date' => [
                'value' => $formEntry->expire_date ?: Carbon::now()->add("1 year")
            ],
            'status'
        ];

        $builder->setFields($fields);
    }
}

