<?php

namespace Visiosoft\ReportsModule\Helpers;

class FormattersHelper
{
    /**
     * @param string $source
     * @return string
     */
    public static function formatSource(string $source): string
    {
        if (!str_contains($source, 'https://')) {
            $source = "https://" . $source;
        }

        if (!str_ends_with($source, "/")) {
            $source .= "/";
        }

        return $source;
    }

    //TODO:: improve, delete or find another way look's like costly
    public static function formatByOperation($query, string $operation)
    {
        foreach ($query as $q) {
            if (strtolower($operation) === "sum") {
                $q->total = number_format($q->total, 2, '.', '');
            }
        }
        return $query;
    }
}