let charts = $(".charts");
charts.each(function () {
    let chartContainer = $(this);
    $.ajax({
        method: "GET",
        url: $(this).data("api_endpoint"),
        accept: 'application/json',
        success: function (data) {
            let formattedData = formatData(data)
            let chartColor = random_rgba();
            const ctx = chartContainer;
            const myChart = new Chart(ctx, {
                type: 'line',
                data: {
                    labels: formattedData.labels,
                    datasets: [
                        {
                            label: '',
                            data: formattedData.datas,
                            backgroundColor: chartColor,
                            borderColor: "transparent",
                            tension: 0.4,
                            fill: true,
                            fillColor: chartColor, // Put the gradient here as a fill color
                            strokeColor: chartColor,
                            pointColor: "transparent",
                            pointStrokeColor: "transparent",
                            pointHighlightFill: "transparent",
                            pointHighlightStroke: "transparent",
                        }
                    ]
                },
                options: {
                    maintainAspectRatio: false,
                    legend: {
                        display: false
                    },
                    plugins: {
                        legend: {
                            display: false
                        },
                        title: {
                            display: false,
                        },
                        tooltip: {
                            enabled: true // <-- this option disables tooltips
                        }
                    },
                    interaction: {
                        intersect: false,
                    },
                    scales: {
                        x: {
                            ticks: {
                                beginAtZero: true
                            },
                            grid: {
                                display: false,
                            },
                            display: true,
                            title: {
                                display: false,
                            },
                        },
                        y: {
                            display: true,
                            title: {
                                display: false,
                            },
                            suggestedMin: 0,
                            suggestedMax: 50
                        }
                    }
                },
            });
        }
    })
})

function formatData(data) {
    let formatted = [];
    let formattedLabels = [];
    let formattedDatas = [];

    $.each(data, function (key, val) {
        formattedLabels.push(val.time);
        formattedDatas.push(val.total);
    })

    formatted.labels = formattedLabels;
    formatted.datas = formattedDatas;


    return formatted
}

function random_rgba() {
    var o = Math.round, r = Math.random, s = 200; // R, G, ve B için 0-200 aralığında renkler oluşturun
    return 'rgba(' + o(r()*s) + ',' + o(r()*s) + ',' + o(r()*s) + ',' + (0.4 + r() * 0.4).toFixed(1) + ')';
}




