<?php namespace Visiosoft\ReportsModule\Report\Contract;

use Anomaly\Streams\Platform\Entry\Contract\EntryRepositoryInterface;

interface ReportRepositoryInterface extends EntryRepositoryInterface
{

    /**
     * @param string $table
     * @param string $column
     * @param string $time_column
     * @param string $operation
     * @param string $duration_type
     * @param int $duration
     * @param string|null $where
     * @param string|null $source
     * @param string|null $source_auth_token
     * @return void
     */
    public function setReport(
        string $table,
        string $column,
        string $time_column,
        string $operation,
        string $duration_type,
        int    $duration,
        string $where = null,
        string $source = null,
        string $source_auth_token = null
    );

    /**
     * @return string
     */
    public function getTable(): string;

    /**
     * @return string
     */
    public function getColumn(): string;

    /**
     * @return string
     */
    public function getSource(): string;

    /**
     * @return string|null
     */
    public function getSourceAuthToken(): string;

    /**
     * @return string|null
     */
    public function getWhere();

    /**
     * @return string
     */
    public function getTimeColumn(): string;

    /**
     * @return string
     */
    public function getOperation(): string;

    /**
     * @return string
     */
    public function getDurationType(): string;

    /**
     * @return int
     */
    public function getDuration(): int;
}
