<?php

namespace Visiosoft\ReportsModule\Http\Controller;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Visiosoft\ReportsModule\Traits\ApiReturnResponseTrait;

class ApiController
{
    use ApiReturnResponseTrait;

    public function getReportByQuery()
    {
        $query = request()->post('query');
        $validator = Validator::make(request()->all(), [
            'query' => ['required', 'string'],
        ]);

        if ($validator->fails()) {
            return $this->sendError($validator->errors(), [], 422);
        }

        if (self::isBlacklisted($query)) {
            return $this->sendError('There are blacklisted statements in your query', [], 401);
        }


        return $this->sendResponse(DB::select(DB::raw($query)));
    }

    private static function isBlacklisted(string $query): bool
    {
        foreach (self::getBlacklistedSqlStatements() as $blacklisted) {
            $pattern = "/\b" . preg_quote($blacklisted, '/') . "\b/";
            if (preg_match($pattern, strtolower($query))) {
                return true;
            }
        }

        return false;
    }

    private static function getBlacklistedSqlStatements(): array
    {
        return ['drop', 'delete', 'truncate', 'update', 'grant', 'privileges', 'create', 'alter', 'insert'];
    }

}