<?php namespace Visiosoft\ReportsModule\Report\Contract;

use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;

interface ReportInterface extends EntryInterface
{
    /**
     * @return string
     */
    public function getName(): string;

    /**
     * @return string
     */
    public function getSource(): string;

    /**
     * @return string
     */
    public function getSourceAuthToken(): string;

    /**
     * @return string
     */
    public function getViewType(): string;

    /**
     * @return string
     */
    public function getReportType(): string;

    /**
     * @return string|null
     */
    public function getReportTable(): ?string;

    /**
     * @return string|null
     */
    public function getColumn(): ?string;

    /**
     * @return string|null
     */
    public function getTimeColumn(): ?string;

    /**
     * @return string|null
     */
    public function getOperation(): ?string;

    /**
     * @return string|null
     */
    public function getDurationType(): ?string;

    /**
     * @return int|null
     */
    public function getDuration(): ?int;

    /**
     * @return string|null
     */
    public function getWhere(): ?string;

    /**
     * @return string|null
     */
    public function getRawQuery(): ?string;

    /**
     * @param string $name
     * @return void
     */
    public function setName(string $name): void;

    /**
     * @param string $source
     * @return void
     */
    public function setSource(string $source): void;

    /**
     * @param string $sourceAuthToken
     * @return void
     */
    public function setSourceAuthToken(string $sourceAuthToken): void;

    /**
     * @param string $viewType
     * @return void
     */
    public function setViewType(string $viewType): void;

    /**
     * @param string $reportType
     * @return void
     */
    public function setReportType(string $reportType): void;

    /**
     * @param string|null $reportTable
     * @return void
     */
    public function setReportTable(?string $reportTable): void;

    /**
     * @param string|null $column
     * @return void
     */
    public function setColumn(?string $column): void;

    /**
     * @param string|null $timeColumn
     * @return void
     */
    public function setTimeColumn(?string $timeColumn): void;

    /**
     * @param string|null $operation
     * @return void
     */
    public function setOperation(?string $operation): void;

    /**
     * @param string|null $durationType
     * @return void
     */
    public function setDurationType(?string $durationType): void;

    /**
     * @param int|null $duration
     * @return void
     */
    public function setDuration(?int $duration): void;

    /**
     * @param string|null $where
     * @return void
     */
    public function setWhere(?string $where): void;

    /**
     * @param string|null $rawQuery
     * @return void
     */
    public function setRawQuery(?string $rawQuery): void;

}
