<?php

namespace Visiosoft\ReportsModule\Helpers;

class QueryHelper
{
    public static function getDbConnection()
    {
        return config('database.default');
    }

    public static function isBlacklisted(string $query): bool
    {
        foreach (self::getBlacklistedSqlStatements() as $blacklisted) {
            $pattern = "/\b" . preg_quote($blacklisted, '/') . "\b/";
            if (preg_match($pattern, strtolower($query))) {
                return true;
            }
        }

        return false;
    }

    public static function getBlacklistedSqlStatements(): array
    {
        return ['drop', 'delete', 'truncate', 'update', 'grant', 'privileges', 'create', 'alter', 'insert'];
    }
}