<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class VisiosoftModuleReportsRenameTable extends Migration
{

    public function up()
    {
        $table = 'reports_report';
        $oldColumn = 'table';
        if (Schema::hasTable($table)) {
            if (Schema::hasColumn($table, $oldColumn)) {
                Schema::table($table, function (Blueprint $table) use ($oldColumn) {
                    $table->renameColumn($oldColumn, 'report_table');
                });
            }
        }
        
        \Illuminate\Support\Facades\DB::table('streams_fields')
            ->where('namespace', 'reports')
            ->where('slug', 'table')
            ->update(['slug' => 'report_table']);
    }

}
