<?php namespace Visiosoft\ReportsModule;

use Anomaly\Streams\Platform\Addon\AddonCollection;
use Anomaly\Streams\Platform\Addon\AddonIntegrator;
use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\ReportsModule\Report\Contract\ReportRepositoryInterface;
use Visiosoft\ReportsModule\Report\ReportRepository;
use Anomaly\Streams\Platform\Model\Reports\ReportsReportEntryModel;
use Visiosoft\ReportsModule\Report\ReportModel;
use Visiosoft\ReportsModule\Token\Contract\TokenRepositoryInterface;
use Visiosoft\ReportsModule\Token\TokenRepository;
use Anomaly\Streams\Platform\Model\Reports\ReportsTokenEntryModel;
use Visiosoft\ReportsModule\Token\TokenModel;
use Illuminate\Routing\Router;

class ReportsModuleServiceProvider extends AddonServiceProvider
{
    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/reports/report' => 'Visiosoft\ReportsModule\Http\Controller\Admin\ReportController@index',
        'admin/reports' => 'Visiosoft\ReportsModule\Http\Controller\Admin\ReportController@index',
        'admin/reports/create' => 'Visiosoft\ReportsModule\Http\Controller\Admin\ReportController@create',
        'admin/reports/edit/{id}' => 'Visiosoft\ReportsModule\Http\Controller\Admin\ReportController@edit',
        'admin/reports/duplicate/{id}' => 'Visiosoft\ReportsModule\Http\Controller\Admin\ReportController@duplicate',
        '/api/reports/get' => 'Visiosoft\ReportsModule\Http\Controller\ReportController@getReports',
        '/report/get/{id}' => [
            'as' => 'visiosoft.module.reports::get_report',
            'uses' => 'Visiosoft\ReportsModule\Http\Controller\ReportController@getReportByLocal',
        ],
        '/api/report/get/{token}' => [
            'as' => 'visiosoft.module.reports::get_report_by_remote',
            'uses' => 'Visiosoft\ReportsModule\Http\Controller\ReportController@getReportByRemote',
        ],
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        ReportsReportEntryModel::class => ReportModel::class,
        ReportsTokenEntryModel::class => TokenModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        ReportRepositoryInterface::class => ReportRepository::class,
        TokenRepositoryInterface::class => TokenRepository::class,
    ];

    /**
     * Register the addon.
     */
    public function register(AddonIntegrator $integrator, AddonCollection $addons)
    {
        $addon = $integrator->register(
            realpath(__DIR__ . '/../addons/visiosoft/reports_widget-extension/'),
            'visiosoft.extension.reports_widget',
            true,
            true
        );
        $addons->push($addon);
    }

}
