<?php namespace Visiosoft\ReportsModule\Http\Controller;

use Carbon\Carbon;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use Visiosoft\ChargingModule\Http\Controller\PublicController;
use Visiosoft\ReportsModule\Report\Contract\ReportRepositoryInterface;
use Visiosoft\ReportsModule\Token\Contract\TokenRepositoryInterface;
use Yajra\DataTables\DataTables;

class ReportController extends PublicController
{
    private $reportsRepository;
    private $tokenRepository;

    public function __construct()
    {
        $this->reportsRepository = app(ReportRepositoryInterface::class);
        $this->tokenRepository = app(TokenRepositoryInterface::class);
    }

    public function getReports()
    {
        return $this->reportsRepository->getReports();
    }

    /**
     * @param $id
     * @return mixed
     */
    public function getReportByLocal($id)
    {
        return $this->reportsRepository->getReportByLocal($id);
    }

    public function getReportByRemote($token)
    {
        $this->checkAuth($token);
        $validator = Validator::make(request()->all(), [
            'table' => ['required', 'max:255', 'string'],
            'column' => ['required', 'max:255', 'string'],
            'time_column' => ['required', 'max:255', 'string'],
            'operation' => ['required', 'max:255', Rule::in(['sum', 'count', 'SUM', 'COUNT'])],
            'duration_type' => ['required', 'max:255', Rule::in('day', 'week', 'month', 'DAY', 'WEEK', 'MONTH')],
            'duration' => ['required', 'max:255', 'int'],
            'where' => ['string']
        ]);

        if ($validator->fails()) {
            return $validator->errors();
        }

        $request = request()->post();


        $this->reportsRepository->setReport(
            $request['table'],
            $request['column'],
            $request['time_column'],
            $request['operation'],
            $request['duration_type'],
            $request['duration'],
            $request['where'] ?? null,
        );

        return $this->reportsRepository->getDataByLocal();
    }

    private function checkAuth($token)
    {
        if (!$token) {
            throw new \Exception('token-required');
        }

        if (!$token = $this->tokenRepository->findBy('token', $token)) {

            throw new \Exception('invalid-token');
        }

        if (!$token->status || $token->expire_date < Carbon::now()) {
            throw new \Exception('invalid-token');
        }


    }

}